import QtQuick 2.3

import wesual.data.Core 1.0
import wesual.Controls 1.0

Item {
    id : tabs

    property string currentLanguage
    property alias  languageListing : repeater.model
    property var    enabledFlags    : []
    property var    opaqueFlags     : []
    property color  background      : UI.color(UI.PrimaryBase)

    readonly property int currentIndex : {
        if (languageListing.length === 0)
            return 0;

        for (var i = 0; i < languageListing.length; ++i) {
            if (languageListing[i].code === currentLanguage) {
                return i;
            }
        }
        return 0;
    }
    implicitWidth  : languageListing.length * 33
    implicitHeight : 26

    visible : languageListing.length > 1

    Row {
        width  : tabs.width
        height : tabs.height

        Repeater {
            id : repeater

            model : null

            delegate : Rectangle {
                id : delegate

                property bool flagEnabled :
                    enabledFlags.indexOf(modelData.code) !== -1

                property bool flagOpaque :
                    opaqueFlags.indexOf(modelData.code) !== -1

                width  : 33
                height : 26

                color : {
                    if (tabs.currentIndex === index)
                        return UI.color(UI.PrimaryPress);
                    else if (mouseArea.pressed)
                        return UI.color(UI.PrimaryPress);
                    else if (mouseArea.containsMouse)
                        return UI.color(UI.PrimaryHover);
                    else
                        return background;
                }


                Rectangle {
                    id : flagContainer

                    width : flag.width
                    height : flag.width
                    anchors.centerIn : parent
                    color  : delegate.color

                    states : State {
                        name : "selected"
                        when : (tabs.currentIndex === index)

                        PropertyChanges {
                            target : flagContainer
                            width : flag.width + 4
                            height : flag.height + 4
                            color : UI.color(UI.PrimaryBase)
                        }
                    }
                    transitions : Transition {
                        PropertyAnimation {
                            properties : "width, height"
                            duration : 150
                        }
                        ColorAnimation {
                            duration : 150
                        }
                    }


                    Image {
                        id : flag

                        width  : 23
                        height : 16
                        anchors.centerIn : parent
                        horizontalAlignment : Image.AlignHCenter
                        verticalAlignment : Image.AlignVCenter
                        source : modelData.flag
                        fillMode : Image.PreserveAspectCrop
                        opacity : !delegate.flagEnabled ? 0.5 : 1.0
                        mipmap : true

                        Rectangle {
                            anchors.fill : flag
                            color   : UI.color(UI.LanguagesOverlay)
                            opacity :
                                !delegate.flagOpaque && !delegate.flagEnabled ?
                                                                       1.0 : 0.0
                        }
                    }
                }
                MouseArea {
                    id : mouseArea

                    anchors.fill : parent
                    hoverEnabled : true
                    onClicked    : currentLanguage = languageListing[index].code
                    cursorShape  : Qt.PointingHandCursor
                }
            }
        }
    }
}
